package editor;

import java.util.ArrayList;

import javax.swing.JOptionPane;

public class ArrayMoveOver {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}
	
	
	public static boolean moveItemsForward(ArrayList<ScreenObject> list) {
		
		if(list == null || list.size() <= 1) {
//			System.out.println("<><>DELME unable to work, size is 0");
			return false;
		}
		
		
		if(!allItemsCanBeMoved(list)) {
			int r = JOptionPane.showConfirmDialog(null, "This operation can only work on:  Widgets, Conveyors, Moving Blocks, and Rogue Blocks.\nUnselect all other kinds of objects?","Cannot move all items forward", JOptionPane.YES_NO_OPTION);
			
			if(r != JOptionPane.YES_OPTION)
				return false;
			
			deselectUnmovableItems(list);
			
		}
		
		
		
//		System.out.println("moving items forward, list is of size: " + list.size() + " before string:  " + convertToString(list));
		
		ScreenObject temp;
		
		for(int i = list.size() - 2; i >= 0; i--) {
			
			if(list.get(i).isSelected() && !list.get(i + 1).isSelected()) {
				
				temp = list.get(i);
				list.set(i, list.get(i + 1));
				list.set(i + 1, temp);
				
			}
			
		}
		
//		System.out.println("moving items forward, list is of size: " + list.size() + " after string:  " + convertToString(list));
		
		
		ensureOrderIntegrity(list);
		
		
		return true;
	}
	
	
	
	public static boolean moveItemsBack(ArrayList<ScreenObject> list) {
		
		if(list == null || list.size() <= 1) {
//			System.out.println("<><>DELME unable to work, size is 0");
			return false;
		}
		
		
		if(!allItemsCanBeMoved(list)) {
			int r = JOptionPane.showConfirmDialog(null, "This operation can only work on:  Widgets, Conveyors, Moving Blocks, and Rogue Blocks.\nUnselect all other kinds of objects?","Cannot move all items backward", JOptionPane.YES_NO_OPTION);
			
			if(r != JOptionPane.YES_OPTION)
				return false;
			
			deselectUnmovableItems(list);
			
		}
		
		
		ScreenObject temp;
		
		for(int i = 1; i < list.size(); i++) {
			
			if(list.get(i).isSelected() && !list.get(i - 1).isSelected()) {
				
				temp = list.get(i);
				list.set(i, list.get(i - 1));
				list.set(i - 1, temp);
				
			}
			
		}
		
		
		ensureOrderIntegrity(list);
		
		
		return true;
	}
	
	
	
	private static String convertToString(ArrayList<ScreenObject> list) {
		
		StringBuffer returnValue = new StringBuffer();
		
		for(ScreenObject o : list) {
			returnValue.append(o.getClickRect().getMinX() + "x" + o.getClickRect().getMinY() + ",  ");
		}
		
		return returnValue.toString();
		
	}
	
	public static boolean allItemsCanBeMoved(ArrayList<ScreenObject> list) {
		
		
		for(ScreenObject so : list) {
			if(so.isSelected() && !movableItem(so)){
				return false;
			}
		}
		
		return true;
		
		
	}
	
	
	public static void deselectUnmovableItems(ArrayList<ScreenObject> list) {
		
		
		for(ScreenObject so : list) {
			if(!movableItem(so)){
				so.setSelected(false);
			}
		}
		
		
	}
	
	public static boolean movableItem(ScreenObject so) {
		if(!(so instanceof RogueBlockScreenObject)
					&& !(so instanceof HorizontalBlockScreenObject)
					&& !(so instanceof VerticalBlockScreenObject) 
					&& !(so instanceof WidgetScreenObject)
					&& !(so instanceof ConveyorScreenObject))
			return false;
		else
			return true;
	}
	
	public static boolean screenObjectAfterMoveables(ScreenObject so) {
		
		if(movableItem(so))
			return false;
		
		if(!screenObjectBeforeMoveables(so))
			return true;
		
		return false;
	}
	
	
	public static boolean screenObjectBeforeMoveables(ScreenObject so) {
		
		if(so instanceof GoalScreenObject || so instanceof HurtzoneScreenObject)
			return true;
		else
			return false;
		
	}
	
	
	public static void ensureOrderIntegrity(ArrayList<ScreenObject> list) {
		
		ArrayList<ScreenObject> beforeList = new ArrayList<ScreenObject>();
		ArrayList<ScreenObject> moveableList = new ArrayList<ScreenObject>();
		ArrayList<ScreenObject> afterList = new ArrayList<ScreenObject>();
		
		
		for(ScreenObject so : list) {
			
			if(screenObjectBeforeMoveables(so)) {
				beforeList.add(so);
			} else if(movableItem(so)) {
				moveableList.add(so);
			} else {
				afterList.add(so);
			}
			
		}
		
		
		list.clear();
		
		for(ScreenObject so : beforeList) {
			list.add(so);
		}
		
		for(ScreenObject so : moveableList) {
			list.add(so);
		}
		
		for(ScreenObject so : afterList) {
			list.add(so);
		}
		
	}
	
}
